/*
 * Copyright (c) 2017 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_DATETIME_H
#define SAILFISH_MDM_DATETIME_H

#include <QObject>
#include <QDate>

namespace Sailfish {
namespace Mdm {

class DateTimeSettingsPrivate;

class Q_DECL_EXPORT DateTimeSettings : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool ready READ ready NOTIFY readyChanged)
    Q_PROPERTY(bool automaticDateTimeUpdate READ automaticDateTimeUpdate WRITE setAutomaticDateTimeUpdate NOTIFY automaticDateTimeUpdateChanged)
    Q_PROPERTY(bool automaticTimeZoneUpdate READ automaticTimeZoneUpdate WRITE setAutomaticTimeZoneUpdate NOTIFY automaticTimeZoneUpdateChanged)
    Q_PROPERTY(QString timeZone READ timeZone WRITE setTimeZone NOTIFY timeZoneChanged)

public:
    DateTimeSettings(QObject *parent = 0);
    ~DateTimeSettings();

    bool ready() const;

    bool automaticDateTimeUpdate() const;
    void setAutomaticDateTimeUpdate(bool enable);

    bool automaticTimeZoneUpdate() const;
    void setAutomaticTimeZoneUpdate(bool enable);

    QString timeZone() const;
    void setTimeZone(const QString &timeZone);

    Q_INVOKABLE void setTime(int hour, int minute);
    Q_INVOKABLE void setDate(const QDate &date);
    Q_INVOKABLE QStringList supportedTimeZones();

signals:
    void readyChanged();
    void automaticDateTimeUpdateChanged();
    void automaticTimeZoneUpdateChanged();
    void timeZoneChanged();
    void timeZoneError();

    void dateTimeChanged();

private:
    Q_DISABLE_COPY(DateTimeSettings)
    DateTimeSettingsPrivate *d;
};

}
}

#endif // SAILFISH_MDM_DATETIME_H
