/*
 * Copyright (c) 2023 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Nemo.FileManager 1.0

Page {
    id: root
    objectName: "SortingPage"

    signal selected(int sortOrder, int sortBy, int directorySort)

    function qsTrIdStrings() {
        //% "Name ascending"
        QT_TRID_NOOP("components-filemanager-la-name_ascending")
        //% "Name descending"
        QT_TRID_NOOP("components-filemanager-la-name_descending")
        //% "Size ascending"
        QT_TRID_NOOP("components-filemanager-la-size_ascending")
        //% "Size descending"
        QT_TRID_NOOP("components-filemanager-la-size_descending")
        //% "Date modified"
        QT_TRID_NOOP("components-filemanager-la-date_modified")
        //% "Extension"
        QT_TRID_NOOP("components-filemanager-la-extension")
    }

    SilicaListView {
        objectName: "SortingSilicaFlickable"

        anchors.fill: parent
        header: PageHeader {
            objectName: "SortPageHeader"

            //% "Sort"
            title: qsTrId("filemanager-he-sort")
        }
        model: ListModel {
            ListElement {
                sortOrder: Qt.AscendingOrder
                sortBy: FileModel.SortByName
                directorySort: FileModel.SortDirectoriesBeforeFiles
                label: "components-filemanager-la-name_ascending"
            }
            ListElement {
                sortOrder: Qt.DescendingOrder
                sortBy: FileModel.SortByName
                directorySort: FileModel.SortDirectoriesAfterFiles
                label: "components-filemanager-la-name_descending"
            }
            ListElement {
                sortOrder: Qt.DescendingOrder
                sortBy: FileModel.SortBySize
                directorySort: FileModel.SortDirectoriesAfterFiles
                label: "components-filemanager-la-size_ascending"
            }
            ListElement {
                sortOrder: Qt.AscendingOrder
                sortBy: FileModel.SortBySize
                directorySort: FileModel.SortDirectoriesAfterFiles
                label: "components-filemanager-la-size_descending"
            }
            ListElement {
                sortOrder: Qt.AscendingOrder
                sortBy: FileModel.SortByModified
                directorySort: FileModel.SortDirectoriesBeforeFiles
                label: "components-filemanager-la-date_modified"
            }
            ListElement {
                sortOrder: Qt.AscendingOrder
                sortBy: FileModel.SortByExtension
                directorySort: FileModel.SortDirectoriesBeforeFiles
                label: "components-filemanager-la-extension"
            }
        }
        delegate: BackgroundItem {
            onClicked: root.selected(sortBy, sortOrder, directorySort)

            height: Math.max(Theme.itemSizeSmall, sortingLabel.height+2*Theme.paddingMedium)
            Label {
                id: sortingLabel
                objectName: "SortingLabel"

                anchors.verticalCenter: parent.verticalCenter
                x: Theme.horizontalPageMargin
                width: parent.width - 2*x
                wrapMode: Text.Wrap
                color: highlighted ? Theme.highlightColor : Theme.primaryColor
                text: qsTrId(label)
            }
        }
    }
}
