/****************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
** Copyright (C) 2013-2016 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Gallery 1.0
import Sailfish.Pickers 1.0
import "private"

PickerDialog {
    id: videoPickerDialog

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? gridView : __silica_applicationwindow_instance.contentItem
        targetPage: videoPickerDialog
    }

    VideoModel {
        id: videoModel
        selectedModel: _selectedModel
    }

    PickerGridView {
        id: gridView

        dialog: videoPickerDialog
        //: Videos search field placeholder text
        //% "Search videos"
        headerPlaceholderText: qsTrId("components_pickers-ph-search_videos")
        emptyPlaceholderText: qsTrId("components_pickers-ph-empty_folder")
        contentType: ContentType.Video
        itemModel: videoModel
        selectedCount: _selectedCount
        clearOnBackstep: _clearOnBackstep
        glassOnly: videoPickerDialog._background
        animationDuration: _animationDuration
        model: videoModel.model
    }
}
