/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2021-2023 Open Mobile Platform LLC <community@omp.ru>
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Nemo.FileManager 1.0
import "private"

Page {
    id: page

    // "Select location"
    // String defined in FilePickerPage.qml
    property string title: qsTrId("components_pickers-he-select_location")
    property string dialogTitle

    property alias showSystemFiles: partitionList.showSystemFiles
    property string selectedPath
    property var acceptDestination
    property int acceptDestinationAction: PageStackAction.Pop
    property bool checkLengthPath: false

    property int sortBy: FileModel.SortByName
    property int sortOrder: Qt.AscendingOrder
    property int directorySort: FileModel.SortDirectoriesWithFiles
    property int caseSensitivity: Qt.CaseSensitive

    allowedOrientations: Orientation.All

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: __silica_applicationwindow_instance.contentItem
        targetPage: page
    }

    onStatusChanged: {
        if (page.status === PageStatus.Active && !acceptDestination) {
            acceptDestination = pageStack.previousPage(page)
        }
    }

    PartitionListView {
        id: partitionList

        header: PageHeader {
            title: page.title
        }

        onSelected: {
            var obj = pageStack.animatorPush(folderPickerDialog, {
                                                 title: page.dialogTitle,
                                                 path: info.path,
                                                 destination: page.acceptDestination,
                                                 destinationAction: page.acceptDestinationAction,
                                                 acceptDestination: page.acceptDestination,
                                                 acceptDestinationAction: page.acceptDestinationAction,
                                                 checkLengthPath: page.checkLengthPath,
                                                 allowedOrientations: page.allowedOrientations
                                             })
        }
    }

    Component {
        id: folderPickerDialog

        FolderPickerDialog {
            allowedOrientations: page.allowedOrientations
            sortBy: page.sortBy
            sortOrder: page.sortOrder
            directorySort: page.directorySort
            caseSensitivity: page.caseSensitivity
            onSelectedPathChanged: page.selectedPath = selectedPath
        }
    }
}
