/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
**
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0
import Aurora.Controls.private 1.0

Item {
    id: popUpItem

    property string text
    property string hint

    property var _parentPopup

    property alias _secondaryIcon: secondIconImage
    property alias icon: iconImage

    property bool _checkable
    property alias _checked: switcherItem.checked
    property bool closeOnClick: !_checkable
    readonly property bool _highlighted: mouseArea.containsPress
    property bool _isHeaderItem
    property alias _isClickable: mouseArea.enabled
    property int _headerBackground: PopupMenuHeader.NoBackground
    property Palette palette: __silica_applicationwindow_instance.palette

    signal clicked()

    anchors {
        left: parent.left
        right: parent.right
    }

    height: Theme.dp(72)
    opacity: enabled ? 1 : Theme.opacityLow

    Rectangle {
        id: highlight

        anchors {
            fill: parent
            leftMargin: _isHeaderItem ? 0 : Theme.paddingSmall
            rightMargin: _isHeaderItem ? 0 : Theme.paddingSmall
        }

        color: _highlighted ? Theme.rgba(palette.highlightColor, 0.2) : Theme.rgba(palette.primaryColor, 0.1)
        visible: _headerBackground == PopupMenuHeader.SolidBackground || _highlighted
        radius: _headerBackground == PopupMenuHeader.SolidBackground ? 0 : Theme.paddingSmall
    }

    Row {
        anchors {
            leftMargin: Theme.paddingSmall
            rightMargin: Theme.paddingSmall
            fill: parent
        }
        spacing: Theme.paddingSmall

        Item {
            id: imageItem

            anchors.verticalCenter: parent.verticalCenter
            width: iconImage.source != "" ? height : Theme.dp(18) - Theme.paddingSmall
            height: Theme.dp(72)

            HighlightImage {
                id: iconImage

                anchors.centerIn: parent

                width: Theme.iconSizeSmallPlus
                height: Theme.iconSizeSmallPlus

                asynchronous: true
                highlighted: _highlighted
                visible: iconImage.source != ""
            }
        }

        Column {
            anchors.verticalCenter: parent.verticalCenter
            width: parent.width
                   - imageItem.width
                   - secondImageItem.width
                   - Theme.paddingSmall * 2

            Label {
                id: textLabel

                width: parent.width
                text: popUpItem.text
                truncationMode: TruncationMode.Fade
                highlighted: _highlighted
                font.pixelSize: Theme.fontSizeMedium
                palette.highlightColor: popUpItem.palette.primaryHighlightColor
                palette.primaryColor: popUpItem.palette.primaryColor
            }

            Label {
                id: hintLabel

                anchors {
                    left: parent.left
                    right: parent.right
                }

                text: popUpItem.hint
                truncationMode: TruncationMode.Fade
                highlighted: _highlighted
                font.pixelSize: Theme.fontSizeExtraSmall
                palette.highlightColor: popUpItem.palette.secondaryHighlightColor
                palette.primaryColor: popUpItem.palette.secondaryColor
                visible: text != ""
            }
        }

        Item {
            id: secondImageItem

            anchors.verticalCenter: parent.verticalCenter
            width: _checkable || secondIconImage.source != ""
                   ? height
                   : Theme.dp(18) - Theme.paddingSmall
            height: Theme.dp(72)

            Switch {
                id: switcherItem

                anchors.centerIn: parent
                width: Theme.dp(72)
                height: width

                highlighted: _highlighted
                visible: _checkable
            }

            HighlightImage {
                id: secondIconImage

                anchors.centerIn: parent
                width: Theme.iconSizeSmallPlus
                height: Theme.iconSizeSmallPlus

                asynchronous: true
                visible: source != "" && !switcherItem.visible
                highlighted: _highlighted
            }
        }
    }

    MouseArea {
        id: mouseArea

        onClicked: {
            popUpItem.clicked()
            _checked = !_checked
            if (closeOnClick && _parentPopup) {
                _parentPopup.close()
            }
        }

        anchors.fill: parent
    }
}
