/****************************************************************************************
**
** Copyright (c) 2022. Open Mobile Platform LLC.
**
****************************************************************************************/

import QtQuick 2.3
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private

Item {
    id: root

    property rect safeZoneRect: Qt.rect(x, y, width, height)

    QtObject {
        property var geometryBinding

        function update() {
            if (typeof __silica_applicationwindow_instance == "undefined") {
                return
            }

            const windowWidth = __silica_applicationwindow_instance.width
            const windowHeight = __silica_applicationwindow_instance.height
            const windowOrientation = __silica_applicationwindow_instance.orientation
            var rect = root.mapToItem(__silica_applicationwindow_instance,
                                      root.x, root.y,
                                      root.width, root.height)

            var intersects = true

            if (__silica_applicationwindow_instance.displayMode === ApplicationDisplayMode.FillScreen
                    && (windowOrientation & Orientation.LandscapeMask)) {
                const rectMinX = rect.x
                const rectMaxX = rect.x + rect.width
                const cutoutMinX = Private.CutoutArea.cutoutRect.x
                const cutoutMaxX = Private.CutoutArea.cutoutRect.x + Private.CutoutArea.cutoutRect.width
                intersects = !(rectMinX > cutoutMaxX || rectMaxX < cutoutMinX)
            }

            if (intersects) {
                var safeZoneMinY = 0
                var safeZoneMinX = 0
                var safeZoneMaxX = 0
                var safeZoneMaxY = 0

                switch (windowOrientation) {
                case Orientation.Portrait:
                    safeZoneMinX = SafeZoneRect.insets.left
                    safeZoneMinY = SafeZoneRect.insets.top
                    safeZoneMaxX = windowWidth - SafeZoneRect.insets.right
                    safeZoneMaxY = windowHeight - SafeZoneRect.insets.bottom
                    break
                case Orientation.Landscape:
                    safeZoneMinX = SafeZoneRect.insets.bottom
                    safeZoneMinY = SafeZoneRect.insets.left
                    safeZoneMaxX = windowWidth - SafeZoneRect.insets.top
                    safeZoneMaxY = windowHeight - SafeZoneRect.insets.right
                    break
                case Orientation.PortraitInverted:
                    safeZoneMinX = SafeZoneRect.insets.right
                    safeZoneMinY = SafeZoneRect.insets.bottom
                    safeZoneMaxX = windowWidth - SafeZoneRect.insets.left
                    safeZoneMaxY = windowHeight - SafeZoneRect.insets.top
                    break
                case Orientation.LandscapeInverted:
                    safeZoneMinX = SafeZoneRect.insets.top
                    safeZoneMinY = SafeZoneRect.insets.right
                    safeZoneMaxX = windowWidth - SafeZoneRect.insets.bottom
                    safeZoneMaxY = windowHeight - SafeZoneRect.insets.left
                    break
                default:
                    break
                }

                if (rect.x < safeZoneMinX) {
                    rect.x = safeZoneMinX
                } else if (rect.x + rect.width > safeZoneMaxX) {
                    rect.x = safeZoneMaxX - rect.width
                }

                if (rect.y < safeZoneMinY) {
                    rect.y = safeZoneMinY
                } else if (rect.y + rect.height > safeZoneMaxY) {
                    rect.y = safeZoneMaxY - rect.height
                }
            }

            root.safeZoneRect = root.mapFromItem(__silica_applicationwindow_instance,
                                                 rect.x, rect.y,
                                                 rect.width, rect.height)
        }

        onGeometryBindingChanged: update()

        Component.onCompleted: {
            geometryBinding = Qt.binding(function()
            {
                var res = root.x
                        + root.y
                        + root.width
                        + root.height
                        + (typeof __silica_applicationwindow_instance == "undefined") ? 0 : 1

                var docRoot = root
                while (docRoot.parent) {
                    docRoot = docRoot.parent
                    res += docRoot.x
                            + docRoot.y
                            + docRoot.width
                            + docRoot.height
                            + (typeof docRoot.orientation !== "undefined") ? docRoot.orientation : 0
                }
                return res
            })
            __silica_applicationwindow_instance.onDisplayModeChanged.connect(update)
            update()
        }
    }
}
