/****************************************************************************
**
** Copyright (c) 2022 Open Mobile Platform LLC.
** Copyright (C) 2013-2016 Jolla Ltd.
** Contact: Raine Mäkeläinen <raine.makelainen@jollamobile.com>
**
****************************************************************************/

import QtQuick 2.0
import QtDocGallery 5.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import "private"

PickerDialog {
    id: documentPickerDialog

    property alias _contentModel: documentModel

    //: Placeholder text of document search field in content picker
    //% "Search documents"
    property string _headerPlaceholderText: qsTrId("components_pickers-ph-search_documents")
    property string _emptyPlaceholderText: qsTrId("components_pickers-ph-empty_folder")

    property alias _contentType: documentModel.contentType

    orientationTransitions: Private.PageOrientationTransition {
        fadeTarget: _background ? gridView : __silica_applicationwindow_instance.contentItem
        targetPage: documentPickerDialog
    }

    DocumentModel {
        id: documentModel
        selectedModel: _selectedModel
    }

    PickerGridView {
        id: gridView

        dialog: documentPickerDialog
        headerPlaceholderText: _headerPlaceholderText
        emptyPlaceholderText: _emptyPlaceholderText
        contentType: _contentType
        itemModel: documentModel
        selectedCount: _selectedCount
        clearOnBackstep: _clearOnBackstep
        glassOnly: documentPickerDialog._background
        animationDuration: _animationDuration
        model: documentModel.model
    }
}
