/*
 * Copyright (c) 2017 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SIMSMSFILTER_H
#define SAILFISH_MDM_SIMSMSFILTER_H

#include <QObject>

#include "mdm-simfilter.h"

namespace Sailfish {
namespace Mdm {
class SimSmsFilterPrivate;

class Q_DECL_EXPORT SimSmsFilter : public QObject
{
    Q_OBJECT
    Q_PROPERTY(bool ready READ ready NOTIFY readyChanged)
    Q_PROPERTY(SimFilter::Action defaultTextAction READ defaultTextAction WRITE setDefaultTextAction NOTIFY defaultTextActionChanged)
    Q_PROPERTY(SimFilter::RuleList textRules READ textRules WRITE setTextRules NOTIFY textRulesChanged)

public:
    SimSmsFilter(QObject *parent = 0);
    ~SimSmsFilter();

    bool ready() const;

    SimFilter::Action defaultTextAction() const;
    bool setDefaultTextAction(SimFilter::Action action);

    SimFilter::RuleList textRules() const;
    bool setTextRules(const SimFilter::RuleList &rules);
    bool clearTextRules();

    bool setTextRule(const SimFilter::Rule &rule);
    bool removeTextRule(const QString &imsi);
    bool hasTextRuleForImsi(const QString &imsi) const;

Q_SIGNALS:
    void readyChanged();
    void defaultTextActionChanged();

    void textRuleAdded(const Sailfish::Mdm::SimFilter::Rule &rule);
    void textRuleRemoved(const QString &imsi);
    void textRulesChanged(const Sailfish::Mdm::SimFilter::RuleList &oldRules, const Sailfish::Mdm::SimFilter::RuleList &newRules);

private:
    SimSmsFilterPrivate *d;
    Q_DISABLE_COPY(SimSmsFilter)
    Q_DECLARE_PRIVATE(SimSmsFilter)
};

}
}

#endif // SAILFISH_MDM_SIMSMSFILTER_H
