#ifndef MDMAPPLICATIONS_H
#define MDMAPPLICATIONS_H

#include <QList>
#include <QObject>
#include <QString>
#include <QtGlobal>

namespace Sailfish {
namespace Mdm {
class ApplicationEntryPrivate;
class PackageEntryPrivate;
class ApplicationOperationPrivate;
class ApplicationsPrivate;

class Q_DECL_EXPORT PackageEntry
{
public:
    PackageEntry();
    PackageEntry(const PackageEntry &other);
    PackageEntry(const QString &name, const QString &version, const QString &vendor);
    PackageEntry &operator=(const PackageEntry &other);

    virtual ~PackageEntry();

    bool isValid() const;
    QString name() const;
    QString version() const;
    QString vendor() const;

private:
    PackageEntryPrivate *d_ptr;
};

class Q_DECL_EXPORT ApplicationEntry
{
public:
    ApplicationEntry(const QString &name, const PackageEntry &package);
    ApplicationEntry(const QString &name,
                     const PackageEntry &package,
                     const QStringList &permissions);
    ApplicationEntry(const ApplicationEntry &other);
    ApplicationEntry &operator=(const ApplicationEntry &other);
    virtual ~ApplicationEntry();

    QString name() const;
    QStringList permissions() const;
    PackageEntry package() const;
    QString iconPath() const;

private:
    ApplicationEntryPrivate *d_ptr;
    Q_DECLARE_PRIVATE(ApplicationEntry)
};

class Q_DECL_EXPORT ApplicationOperation : public QObject
{
    Q_OBJECT

public:
    bool isFinished() const;
    bool isSucceeded() const;

    QString package() const;
    QString version() const;

    QString errorString() const;

signals:
    void finished(ApplicationOperation *applicationOperation);
    void failed(ApplicationOperation *applicationOperation);
    void succeeded(ApplicationOperation *applicationOperation);

private slots:
    void setError(const QString &errorString);
    void setFinished();
    void setFinishedWithError();

protected:
    explicit ApplicationOperation();
    virtual ~ApplicationOperation();

private:
    friend class Applications;
    ApplicationOperationPrivate *d_ptr;
    Q_DISABLE_COPY(ApplicationOperation)
    Q_DECLARE_PRIVATE(ApplicationOperation)
};

class Q_DECL_EXPORT Applications : public QObject
{
    Q_OBJECT

public:
    explicit Applications(QObject *parent = 0);
    virtual ~Applications();

    QList<ApplicationEntry> getInstalledApplications();
    QList<ApplicationEntry> getInstalledApplications(uint uid);
    ApplicationEntry getInstalledApplicationInfo(uint uid = 0, QString appName = "");
    QList<PackageEntry> getInstalledPackages();
    bool grantPermissions(uint uid, bool always, const QString &application);

    ApplicationOperation *installPackage(const QString &package, const QString &version = QString());
    ApplicationOperation *removePackage(const QString &package, bool autoremove);

private:
    ApplicationsPrivate *d_ptr;
    Q_DISABLE_COPY(Applications)
    Q_DECLARE_PRIVATE(Applications)
};

} // namespace Mdm
} // namespace Sailfish

#endif // MDMAPPLICATIONS_H
