/*
 * Copyright (c) 2021 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */
pragma Singleton

import QtQuick 2.0
import Nemo.FileManager 1.0

Item {
    property string selectedSortType
    property var sortBy: FileModel.SortByModified
    property var sortOrder: Qt.AscendingOrder
    property var directorySort: FileModel.SortDirectoriesBeforeFiles

    function setSortType(_sortBy, _sortOrder, _directorySort) {
        sortBy = _sortBy
        sortOrder = _sortOrder
        directorySort = _directorySort

        switch (_sortBy) {
        case FileModel.SortByName:
            //: Shown Sorted by name regardless of type: in ascending/descending order
            //% "name"
            selectedSortType = qsTrId("components-filemanager-la-sorted_by_name")
            break
        case FileModel.SortByModified:
            //: Shown Sorted by date modified
            //% "date modified"
            selectedSortType = qsTrId("components-filemanager-la-sorted_by_date_modified")
            break
        case FileModel.SortBySize:
            //: Shown Sorted by size
            //% "size"
            selectedSortType = qsTrId("components-filemanager-la-sorted_by_size")
            break
        case FileModel.SortByExtension:
            //: Shown Sorted by extension
            //% "extension"
            selectedSortType = qsTrId("components-filemanager-la-sorted_by_extension")
            break
        }
    }
}
