#!/bin/bash

unblock_developer_mode="dbus-send --system \
                        --type=method_call \
                        --print-reply=literal \
                        --dest=ru.omp.developermode \
                        / \
                        ru.omp.developermode.SetBlocked \
                        boolean:false"

check_response() {
    if [ $? -ne 0 ]; then
        echo "$1"
        exit 1
    fi
}

if [ $# -eq 0 ]; then
    echo "No user was provided."
    exit 1
fi

username=$(getent passwd "$1" | cut -f 1 -d ":")
check_response "Can't get username"

# check if user is privileged
tmp=$(groups "$username" | grep -w sailfish-system)
if [ $? -eq 0 ]; then
    echo "Privileged user."
    response=$($unblock_developer_mode)
    echo $responce
fi

exit 0
