/*
 * Copyright (c) 2021 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_DEVICELOCKSETTINGS_H
#define SAILFISH_MDM_DEVICELOCkSETTINGS_H

#include <QString>
#include <QDBusVariant>
#include <QDBusInterface>
#include <QObject>
#include <QSharedPointer>

namespace Sailfish {
namespace Mdm {

class Q_DECL_EXPORT DeviceLockSettings : public QObject
{
    Q_OBJECT

public:

    explicit DeviceLockSettings(QObject *parent = nullptr);

    static QList<Qt::DayOfWeek> fromStringScheduleDays(const QString &schedDays);
    static QPair<QTime, QTime> fromStringScheduleTime(const QString &schedTime);

    bool setPasswordStrength(bool strength);
    bool getPasswordStrength();

    bool setPasswordLength(uint length);
    uint getPasswordLength();

    bool setPasswordMaxAge(uint days);
    uint getPasswordMaxAge();

    bool setPasswordWarningPeriod(uint days);
    uint getPasswordWarningPeriod();

    bool setLoginTimeToLive(uint uid, QDate ttl);
    QDate getLoginTimeToLive(uint uid);

    bool setScheduleDays(uint uid, const QList<Qt::DayOfWeek> &schedDays);
    QList<Qt::DayOfWeek> getScheduleDays(uint uid);

    bool setScheduleTime(uint uid, const QPair<QTime, QTime> &schedTime);
    QPair<QTime, QTime> getScheduleTime(uint uid);

private:
    QDBusInterface m_iface;
    Q_DISABLE_COPY(DeviceLockSettings)
};
} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_DEVICELOCKSETTINGS_H

