#ifndef MDM_SETTINGS_H
#define MDM_SETTINGS_H

#include <QDBusInterface>
#include <QObject>
#include <QStringList>
#include <QVariant>

namespace Sailfish {
namespace Mdm {

class SettingsPrivate;

class Q_DECL_EXPORT Settings : public QObject
{
    Q_OBJECT
public:
    Settings(QObject *parent = 0);
    ~Settings() = default;

    bool setValues(const QVariantMap &settingsToSave);
    QVariant getValue(const QString &key) const;
    bool remove(const QString &key);
    QStringList allKeys() const;

    bool clear();

private:
    SettingsPrivate *d_ptr;

    Q_DISABLE_COPY(Settings)
};

} // namespace Mdm
} // namespace Sailfish

#endif
