/*
 * Copyright (c) 2018 - 2020 Jolla Ltd.
 *
 * License: Proprietary
 */

#ifndef SAILFISH_MDM_SIMFILTER_H
#define SAILFISH_MDM_SIMFILTER_H

#include <QObject>

namespace Sailfish {
namespace Mdm {

class Q_DECL_EXPORT SimFilter : public QObject
{
    Q_OBJECT
public:
    enum Action {
        Block  = 1,
        Ignore = Block, // for Incoming calls
        Allow  = 2,
        Hangup = 3
    };
    Q_ENUM(Action)

    struct Rule {
        QString imsi;
        Action action;

        Rule(const QString &imsi, Action action);
        Rule();
        bool operator==(const Rule &rule) const;
        bool operator!=(const Rule &rule) const;
        operator const QString() const;
    };
    typedef QList<Rule> RuleList;

    static bool isValidImsi(const QString &imsi);

private:
    explicit SimFilter(QObject *parent = nullptr);
};

}
}

Q_DECLARE_METATYPE(Sailfish::Mdm::SimFilter::Rule)
Q_DECLARE_METATYPE(Sailfish::Mdm::SimFilter::RuleList)

QDebug operator<<(QDebug, const Sailfish::Mdm::SimFilter::Action &action) Q_DECL_EXPORT;

QDebug operator<<(QDebug, const Sailfish::Mdm::SimFilter::Rule *rule) Q_DECL_EXPORT;

#endif // SAILFISH_MDM_SIMFILTER_H
