/* This file is part of the Aurora SDK
*/

// Keep tooling and target templates code in sync!

var type = "target";
// Keep the name in sync with org.merproject.targets.target4qtcreator!
var name = "latest" === "ea"
    ? "AuroraOS-5.1.6.110-MB2EA-x86_64"
    : "AuroraOS-5.1.6.110-MB2-x86_64";
var image = "Aurora_OS-5.1.6.110-MB2-Aurora_SDK_Target-x86_64.tar";
var archive = "Aurora_OS-5.1.6.110-MB2-Aurora_SDK_Target-x86_64.tar.7z";
var toolingName = name.replace(/-[^-]+$/, "");
var sharedMountPoint = "/host_targets";

function Component()
{
    console.log("Component constructor: " + component.name);
    if ("latest" === "5.1.6.110-MB2") {
        component.setValue("DisplayName", "AuroraOS-latest-x86_64");
        component.setValue("Description",
                qsTranslate("installscript", "Enables development for %1 devices running %2 release %3 " +
                        "or any later backward-compatible release")
                    .arg("x86_64")
                    .arg("Aurora OS")
                    .arg("5.1.6.110-MB2"));
    } else if ("latest" === "ea") {
        component.setValue("Description",
                qsTranslate("installscript", "Enables development for %1 devices running the latest %2 release " +
                        "published to Early Access users " +
                        "(%3) or any later backward-compatible release")
                    .arg("x86_64")
                    .arg("Aurora OS")
                    .arg("5.1.6.110-MB2"));
    } else if ("latest" === "latest") {
        component.setValue("Description",
                qsTranslate("installscript", "Enables development for %1 devices running the latest %2 release " +
                        "(%3) or any later backward-compatible release")
                    .arg("x86_64")
                    .arg("Aurora OS")
                    .arg("5.1.6.110-MB2"));
    } else {
        component.setValue("Description", "*** TRANSLATION MISSING !! ***");
    }

    // Attention: during update the component may get loaded twice: for the installed version and
    // for the updated version. As a result the ctor may be called twice with different results.
    if (installer.value("merSdkTargets"))
        Component.prototype.ctor();
    installer.componentByName("org.merproject.mersdk").loaded.connect( this, Component.prototype.ctor );
}

Component.prototype.ctor = function()
{
    component.isPreinstalled = false;

    var merSdk = installer.componentByName("org.merproject.mersdk");
    var merSdkWillBeInstalledOrUpdated = merSdk.value("Version") &&
        merSdk.value("InstalledVersion") != merSdk.value("Version");
    var thisIsPreinstalled = installer.value("merSdkTargets").split(" ").indexOf(name) != -1;

    if (merSdkWillBeInstalledOrUpdated && thisIsPreinstalled) {
        console.log("Forcing installation of " + name + " (may change later)");
        component.isPreinstalled = true;
        // Favor AutoDependOn over ForcedInstallation which does not work during update
        component.setValue("AutoDependOn", component.value("Dependencies"));
        if (component.isFromOnlineRepository())
            component.removeDownloadableArchive(component.value("Version") + archive);
    } else {
        // Checking component.isPreinstalled does not work as expected, need to check AutoDependOn instead
        if (component.value("AutoDependOn")) {
            console.log("Clearing forced installation of " + name + " (may change later)");
            component.isPreinstalled = false;
            component.setValue("AutoDependOn", "");
            if (component.isFromOnlineRepository())
                component.addDownloadableArchive(archive);
        } else {
            console.log("Not forcing installation of " + name + " (may change later)");
        }
    }
}

Component.prototype.createOperationsForArchive = function(archive)
{
    component.addOperation("Extract", archive, "@merSdkSharedTargetsDir@");
}

Component.prototype.createOperations = function()
{
    if (!component.isPreinstalled)
        component.createOperations();

    var noop = installer.value("os") === "win"
        ? [ "cmd", "/c", "exit" ]
        : [ "true" ]
    var noopIfPreinstalled = component.isPreinstalled ? noop : []

    Array.prototype.flat1 = function() {
        return this.reduce(function(acc, val) { return acc.concat(val) }, []);
    }

    var uncompressedSizeMb = Math.ceil(parseInt(component.value("UncompressedSize"))
            / (1024*1024));
    // In practise targets take about 1.1 * UncompressedSize on the vm. Let's
    // multiply by two to be on the safe side
    var freeSizeMb = uncompressedSizeMb * 3;
    var incrementSizeMb = uncompressedSizeMb * 7; // to make room for other targets too
    var freeStorageArg = "vm.free-storage-size=" + freeSizeMb + "+,"
        + incrementSizeMb;

    var enginectl = [
        "@sfdkPath@",
        "-C", "$WORKSPACE",
        "--system-config-only",
        // "--build-engine=@merSdkVmUri@", // TODO allow for multiple build engines
        "engine"
    ];

    component.addOperation("EnvironmentVariable", "SFDK_AUTO_STOP_VMS", "1", "false");

    if (installer.value("buildEngineType") === "vbox") {
        component.addOperation("Execute", [
            "{0,1}",
            noopIfPreinstalled, enginectl, "set", freeStorageArg,
            "errormessage=" + qsTranslate("installscript", "Failed to increase VM storage size."),
            ].flat1());
    }

    component.addOperation("Execute", [
        noopIfPreinstalled, enginectl, "start",
        "errormessage=" + qsTranslate("installscript", "Failed to start the build engine."),
        "UNDOEXECUTE",
        enginectl, "stop",
        "errormessage=" + qsTranslate("installscript", "Failed to stop the build engine."),
        ].flat1());

    component.addOperation("Execute", [
        noopIfPreinstalled, enginectl, "exec", "sdk-manage", "--mode", "installer", type, "install", name,
        sharedMountPoint + "/" + image,
        "--tooling", toolingName,
        "errormessage=" + qsTranslate("installscript", "Failed to install the component into the build engine."),
        "UNDOEXECUTE",
        enginectl, "exec", "sdk-manage", "--mode", "installer", type, "remove",
        "--force", name,
        "errormessage=" + qsTranslate("installscript", "Failed to remove the component from the build engine."),
        ].flat1());

    component.addOperation("Execute", [
        noop, // see merSdkNeedsStop below
        "UNDOEXECUTE",
        enginectl, "start",
        "errormessage=" + qsTranslate("installscript", "Failed to start the build engine."),
        ].flat1());

    if (!component.isPreinstalled) {
        installer.setValue("merSdkNeedsStop", "true");
        installer.installationFinished.connect( this, function() {
            if (installer.value("merSdkNeedsStop")) {
                installer.setValue("merSdkNeedsStop", "");
                var result = installer.execute(enginectl[0], enginectl.slice(1).concat("stop"));
                if (!result || result[1] != 0) {
                    QMessageBox.warning("mersdk.stop-failed", qsTranslate("installscript", "The Virtual Machine is Running"),
                            qsTranslate("installscript", "The headless build engine virtual machine could not be stopped."));
                }
            }
        });
    }

    if (!component.isPreinstalled) {
        var merSdkSharedTargetsDir = installer.value("merSdkSharedTargetsDir");

        // Remove the installation image
        rmWithoutUndo(merSdkSharedTargetsDir + "/" + image);
    }

    // Failing to clear the forced installation at this point would break the possibility to
    // deselect the package with package manager when no online repository is available.
    if (component.isPreinstalled) {
        console.log("Clearing forced installation of " + name);
        component.isPreinstalled = false;
        component.setValue("AutoDependOn", "");
        if (component.isFromOnlineRepository())
            component.addDownloadableArchive(archive);
    }
}

function toNativePath(path)
{
    if (installer.value("os") === "win")
        return path.replace(/\//g, "\\");
    else
        return path;
}

function rmWithoutUndo(path)
{
        path = toNativePath(path);
        if (installer.value("os") === "win") {
            component.addOperation("Execute", "cmd", "/c", "del " + path);
        } else {
            component.addOperation("Execute", "rm", path);
        }
}

function mvWithoutUndo(src, dst)
{
    src = toNativePath(src);
    dst = toNativePath(dst);

    if (installer.value("os") === "win") {
        component.addOperation("Execute", "cmd", "/c", "move " + src + " " + dst);
    } else {
        component.addOperation("Execute", "mv", src, dst);
    }
}
