/*
 * This file is part of the Aurora OS SDK
 */

Component.prototype.beginInstallation = function()
{
    var os = installer.value('os');

    if (os === "win")
       component.setStopProcessForUpdateRequest("qtcreator.exe", true);
    else if (os === "mac")
	component.setStopProcessForUpdateRequest("Qt Creator", true);
    else
	component.setStopProcessForUpdateRequest("qtcreator", true);
}

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Aurora OS Project Templates"));
    component.setValue("Description", component.value("DisplayName"));
}

Component.prototype.createOperationsForArchive = function(archive)
{
    var os = installer.value('os');
    var templateDir = installer.value("TargetDir");

    if (os === "mac") {
	templateDir += "/bin/Qt Creator.app/Contents/Resources/templates/wizards/"
    }
    else {
	templateDir += "/share/qtcreator/templates/wizards/";
    }

    component.addOperation("Extract",
			   archive,
			   templateDir);
}
