    /* This file is part of the Aurora OS SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();

    var deviceModels = installer.componentByName("org.merproject.emulators").deviceModels;
    deviceModels.forEach(addMerDeviceModelToQtCreator);
}

function addMerDeviceModelToQtCreator(deviceModel)
{
    var sdkTool = installer.value("SDKToolBinary");
    var installDir = installer.value("TargetDir");

    var errorMessage = "errormessage=" +  qsTranslate("installscript", "Could not remove the device model \"%1\"").arg(deviceModel.name);
    component.addOperation("Execute", ["{0,2,3}", sdkTool, "rmSfdkDeviceModel",
                                       "--name", deviceModel.name, errorMessage]);
    component.addOperation("Execute", ["{0,1}", sdkTool, "addSfdkDeviceModel",
                                       "--installdir", installDir,
                                       "--name", deviceModel.name,
                                       "--hres-px", deviceModel.hres_px,
                                       "--vres-px", deviceModel.vres_px,
                                       "--hsize-mm", deviceModel.hsize_mm,
                                       "--vsize-mm", deviceModel.vsize_mm,
                                       "--dconf-db", deviceModel.dconfDb,
                                       "UNDOEXECUTE",
                                       "{0,1}", sdkTool, "rmSfdkDeviceModel",
                                       "--name", deviceModel.name, errorMessage
                           ]);
}
