    /* This file is part of the Aurora OS SDK
*/

// Keep these in sync with org.merproject.emulator [[Begin
var emulatorVmName = "latest" === "ea"
    ? "AuroraOS-5.1.6.110-MB2EA"
    : "AuroraOS-5.1.6.110-MB2";
var emulatorVmSnapshotName = "5.1.6.110-MB2";
var emulatorMemoryMB = "4096";
var emulatorCpuCount = "1";
// End]]

var emulatorVmUri = "sfdkvm:VirtualBox#" + emulatorVmName;
var emulatorProductName = "Aurora OS";
var emulatorProductRelease = "latest" === "ea"
    ? "5.1.6.110-MB2EA"
    : "5.1.6.110-MB2";

var emulatorVdiCapacityMB = "8192";

var emulatorIdx = 0;
var sshPort = 2223 + emulatorIdx;
var freePortsRangeStart = 20000 + 20 * emulatorIdx;
var freePortsRangeEnd = 20019 + 20 * emulatorIdx;
var qmlLivePort = 10234 + emulatorIdx;

if (emulatorIdx > 14)
    throw "Too many emulators";
var macAddress2 = "08:00:5A:11:00:" + (emulatorIdx + 1).toString(16).padStart(2, '0');

var sharedSshDir =  "@TargetDir@/emulator/" + emulatorVmName + "/ssh";
var sharedConfigDir = "@TargetDir@/emulator/" + emulatorVmName + "/vmshare";
var sharedMediaDir = "@TargetDir@/emulator/media";

var deviceModelDconfDbFile = sharedConfigDir + "/device-model.txt";
var deviceModelEglfsConfigFile = sharedConfigDir + "/65-emul-wayland-ui-scale.conf";

var userName;

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "%1-%2%3 Emulator Integration for Aurora IDE")
        .arg("AuroraOS")
        .arg("latest")
        .arg("latest" != "5.1.6.110-MB2" ? " (5.1.6.110-MB2)" : ""));
}

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();

    var versionNumber = "5.1.6.110-MB2".split(".");
    // we don't have to care about version numbers smaller than 3.0
    if (versionNumber[0] > 3 || versionNumber[1] > 3) {
        userName = "defaultuser";
    } else {
        userName = "nemo";
    }

    var vboxManagePath = installer.value("vboxManagePath");
    component.setValue("vmInfo", "");
    component.addOperation("ConsumeOutput", "vmInfo", vboxManagePath, ["showvminfo", emulatorVmName, "--machinereadable"]);
    var portForwardingExists = function(port) {
        return component.value("vmInfo").match(new RegExp("Forwarding\(\d+\)=\"" + port));
    }

    if (portForwardingExists("guestssh")) {
        component.addOperation("Execute", ["{0,1}", vboxManagePath, "modifyvm", emulatorVmName,
                                           "--natpf1", "delete", "guestssh"
        ]);
    }
    if (portForwardingExists("qmllive_1")) {
        component.addOperation("Execute", ["{0,1}", vboxManagePath, "modifyvm", emulatorVmName,
                                           "--natpf1", "delete", "qmllive_1"
        ]);
    }

    component.addOperation("Execute", [vboxManagePath, "modifyvm", emulatorVmName,
                                       "--natpf1", "guestssh,tcp,127.0.0.1," + sshPort + ",,22",
                                       // qmllive_%d format required/recognized by Qt Creator!
                                       "--natpf1", "qmllive_1,tcp,127.0.0.1," + qmlLivePort + ",," + qmlLivePort,
                                       "--macaddress2", macAddress2.split(":").join("")
    ]);

    // FIXME breaks when the port is later changed by user
    if (installer.value("buildEngineType") === "docker") {
        // Removed the creation of guestssh4docker port forwarding but kept the deletion to prevent potential issues during updates (see SDK-1688).
        if (portForwardingExists("guestssh4docker")) {
            component.addOperation("Execute", ["{0,1}", vboxManagePath, "modifyvm", emulatorVmName,
                                            "--natpf1", "delete", "guestssh4docker"
            ]);
        }

        if (installer.value("os") === "win") {
            component.addOperation("Execute", ["{0,1}", vboxManagePath, "modifyvm", emulatorVmName,
                                                "--ioapic", "off"
            ]);
        }
    }

    for (var freePort = freePortsRangeStart; freePort <= freePortsRangeEnd; freePort++) {
        if (portForwardingExists("freeport_" + freePort)) {
            component.addOperation("Execute", ["{0,1}", vboxManagePath, "modifyvm", emulatorVmName,
                                               "--natpf1", "delete", "freeport_" + freePort
            ]);
        }
        component.addOperation("Execute", [vboxManagePath, "modifyvm", emulatorVmName,
                                           "--natpf1", "freeport_" + freePort + ",tcp,127.0.0.1," + freePort + ",," + freePort
        ]);
    }

    var errorMessage = "errormessage=" +  qsTranslate("installscript", "Please shutdown the \"%1\" VM").arg(emulatorVmName);

    component.addOperation("Mkdir", sharedSshDir);
    component.addOperation("Execute", [vboxManagePath, "sharedfolder",
                                       "add", emulatorVmName,
                                       "--name", "ssh",
                                       "--hostpath", sharedSshDir,
                                       "--readonly",
                                       "UNDOEXECUTE",
                                       "{0,1}", vboxManagePath, "sharedfolder",
                                       "remove", emulatorVmName,
                                       "--name", "ssh", errorMessage
    ]);
    component.addOperation("Mkdir", sharedConfigDir);
    component.addOperation("Execute", [vboxManagePath, "sharedfolder",
                                       "add", emulatorVmName,
                                       "--name", "config",
                                       "--hostpath", sharedConfigDir,
                                       "--readonly",
                                       "UNDOEXECUTE",
                                       "{0,1}", vboxManagePath, "sharedfolder",
                                       "remove", emulatorVmName,
                                       "--name", "config", errorMessage
    ]);

    component.addOperation("Execute", [vboxManagePath, "sharedfolder",
                                       "add", emulatorVmName,
                                       "--name", "media",
                                       "--hostpath", sharedMediaDir,
                                       "--readonly",
                                       "UNDOEXECUTE",
                                       "{0,1}", vboxManagePath, "sharedfolder",
                                       "remove", emulatorVmName,
                                       "--name", "media", errorMessage
    ]);

    var snapshotExists = installer.execute(vboxManagePath, ["snapshot", emulatorVmName, "list"])[1] == 0;

    if (!snapshotExists) {
        component.addOperation("Execute", [vboxManagePath, "snapshot",
                                           emulatorVmName, "take",
                                           emulatorVmSnapshotName,
                                           "--description",
                                           qsTranslate("installscript", "Snapshot taken by the SDK Installer/Maintenance Tool")
                                           ]);
    }

    deploySshKeys();

    var initialDeviceModel = installer.componentByName("org.merproject.emulators").initialDeviceModel;

    component.addOperation("Delete", deviceModelDconfDbFile);
    component.addOperation("AppendFile", deviceModelDconfDbFile, initialDeviceModel.dconfDb);
    component.addOperation("Delete", deviceModelEglfsConfigFile);
    component.addOperation("AppendFile", deviceModelEglfsConfigFile, initialDeviceModel.eglfConfig());

    addMerDeviceToQtCreator(initialDeviceModel);
    component.registerPathForUninstallation(sharedConfigDir, true);
}

function addMerDeviceToQtCreator(initialDeviceModel)
{
    var installDir = installer.value("TargetDir");
    var sdkTool = installer.value("SDKToolBinary");
    var errorMessage = "errormessage=" +  qsTranslate("installscript", "Could not remove the device \"%1\"").arg(emulatorVmName);
    component.addOperation("Execute", ["{0,2,3}", sdkTool, "rmSfdkEmulator",
                                       "--vm-uri", emulatorVmUri, errorMessage]);
    component.addOperation("Execute", ["{0,1}", sdkTool, "addSfdkEmulator",
                                       "--installdir", installDir,
                                       "--product-name", emulatorProductName,
                                       "--product-release", emulatorProductRelease,
                                       "--vm-uri", emulatorVmUri,
                                       "--vm-factory-snapshot", emulatorVmSnapshotName,
                                       "--autodetected", "true",
                                       "--shared-ssh", sharedSshDir,
                                       "--shared-config", sharedConfigDir,
                                       "--host", "127.0.0.1",
                                       "--username", userName,
                                       "--private-key-file", "@merSdkSshKeyFile@",
                                       "--ssh-port", sshPort,
                                       "--qml-live-ports", qmlLivePort,
                                       "--free-ports", freePortsRangeStart + "-" + freePortsRangeEnd,
                                       "--mac", macAddress2,
                                       "--subnet", "10.220.220" ,
                                       "--device-model", initialDeviceModel.name,
                                       "--view-scaled", initialDeviceModel.isScaledDown() ? "true" : "false",
                                       "UNDOEXECUTE",
                                       "{0,1}", sdkTool, "rmSfdkEmulator",
                                       "--vm-uri", emulatorVmUri, errorMessage
                           ]);
}

function deploySshKeys()
{
    var sharedSshDirUser = sharedSshDir + "/" + userName + "/";
    var sharedSshDirRoot = sharedSshDir + "/root/";

    component.addOperation("Mkdir", sharedSshDirUser);
    component.addOperation("Mkdir", sharedSshDirRoot);

    var authorizedKeysBaseName = "authorized_keys";
    component.addOperation("Copy", "@merSdkSshKeyPublicFile@", sharedSshDirUser + authorizedKeysBaseName);
    component.addOperation("Copy", "@merSdkSshKeyPublicFile@", sharedSshDirRoot + authorizedKeysBaseName);
}
