/* This file is part of the Aurora SDK
*/

function Component()
{
    console.log("Component constructor: " + component.name);
    component.setValue("DisplayName", qsTranslate("installscript", "Qt SDK Documentation"));
    component.setValue("Description", qsTranslate("installscript", "The Documentation for the Qt SDK"));
}

Component.prototype.beginInstallation = function()
{
    if (installer.value("os") === "win") 
       component.setStopProcessForUpdateRequest("qtcreator.exe", true);
} 

Component.prototype.createOperations = function()
{
    // Call the base createOperations
    component.createOperations();
    component.addOperation("Settings",
                           "path=" + installer.value("QtCreatorInstallerSettingsFile"),
                           "method=set",
                           "key=Help/InstalledDocumentation",
                           "value=@TargetDir@/documentation/");
}
