/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_FILES_KEYS_P_H
#define AURORA_MDM_FILES_KEYS_P_H

#include <QString>

namespace {

namespace Error {

const auto NotEnoughSpace = QStringLiteral("NotEnoughSpace");
const auto ExecutableFile = QStringLiteral("ExecutableFile");
const auto InvalidPath = QStringLiteral("InvalidPath");
const auto InvalidTmpPath = QStringLiteral("InvalidTmpPath");
const auto UserFilesAffected = QStringLiteral("UserFilesAffected");
const auto OverwritingIsImpossible = QStringLiteral("OverwritingIsImpossible");

} // namespace Error

namespace Key {

const auto Name = QStringLiteral("name");
const auto Owner = QStringLiteral("owner");
const auto Type = QStringLiteral("type");
const auto isExecutable = QStringLiteral("isExecutable");

} // namespace Key

} // anonymous namespace

#endif // AURORA_MDM_FILES_KEYS_P_H
