// SPDX-FileCopyrightText: 2016 Jolla Ltd.
// SPDX-FileCopyrightText: 2019 Open Mobile Platform LLC <community@omp.ru>
// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "operation.h"

class RmSfdkDeviceModelOperation: public Operation
{
public:
    RmSfdkDeviceModelOperation();
public:
    QString name() const;
    QString helpText() const;
    QString argumentsHelpText() const;

    bool setArguments(const QStringList &args);

    int execute() const;

#ifdef WITH_TESTS
    bool test() const;
#endif
    static QVariantMap removeDeviceModel(const QVariantMap &map, const QString &name);

private:
    QString m_name;
};
