// SPDX-FileCopyrightText: 2013 Digia Plc and/or its subsidiary(-ies).
// SPDX-FileCopyrightText: 2013-2014 Jolla Ltd.
// SPDX-FileCopyrightText: 2019 Open Mobile Platform LLC <community@omp.ru>
// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "operation.h"

#include <QUrl>

class RmSfdkBuildEngineOperation: public Operation
{
public:
    RmSfdkBuildEngineOperation();
public:
    QString name() const;
    QString helpText() const;
    QString argumentsHelpText() const;

    bool setArguments(const QStringList &args);

    int execute() const;

#ifdef WITH_TESTS
    bool test() const;
#endif
    static QVariantMap removeBuildEngine(const QVariantMap &map, const QUrl &vmUri);

private:
    QUrl m_vmUri;
};
