// SPDX-FileCopyrightText: 2013 Digia Plc and/or its subsidiary(-ies).
// SPDX-FileCopyrightText: 2013-2014,2017,2019 Jolla Ltd.
// SPDX-FileCopyrightText: 2019 Open Mobile Platform LLC <community@omp.ru>
// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "operation.h"

#include <utils/portlist.h>

#include <QUrl>

class AddSfdkEmulatorOperation : public Operation
{
public:
    AddSfdkEmulatorOperation();
    QString name() const;
    QString helpText() const;
    QString argumentsHelpText() const;

    bool setArguments(const QStringList &args);

    int execute() const;

#ifdef WITH_TESTS
    bool test() const;
#endif

    static QVariantMap addEmulator(const QVariantMap &map,
           const QString &productName,
           const QString &productRelease,
           const QUrl &vmUri,
           const QDateTime &creationTime,
           const QString &vmFactorySnapshot,
           bool autodetected,
           const QString &sharedSshPath,
           const QString &sharedConfigPath,
           const QString &host,
           const QString &userName,
           const QString &privateKeyFile,
           quint16 sshPort,
           const QString &qmlLivePorts,
           const QString &freePorts,
           const QString &mac,
           const QString &subnet,
           const QVariantMap &deviceModelMap,
           bool viewScaled);
    static QVariantMap initializeEmulators(const QString &installDir, int version = -1);

private:
    QString m_installDir;
    QString m_productName;
    QString m_productRelease;
    QUrl m_vmUri;
    QString m_vmFactorySnapshot;
    bool m_autodetected = true;
    QString m_sharedSshPath;
    QString m_sharedConfigPath;
    QString m_host;
    QString m_userName;
    QString m_privateKeyFile;
    quint16 m_sshPort = 0;
    QString m_qmlLivePorts;
    QString m_freePorts;
    QString m_mac;
    QString m_subnet;
    QString m_deviceModelName;
    bool m_viewScaled = false;
};
