// SPDX-FileCopyrightText: 2013 Digia Plc and/or its subsidiary(-ies).
// SPDX-FileCopyrightText: 2013-2014,2017,2019 Jolla Ltd.
// SPDX-FileCopyrightText: 2019 Open Mobile Platform LLC <community@omp.ru>
// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "operation.h"

#include <utils/portlist.h>

#include <QUrl>

class AddSfdkBuildEngineOperation : public Operation
{


public:
    AddSfdkBuildEngineOperation();
    QString name() const;
    QString helpText() const;
    QString argumentsHelpText() const;

    bool setArguments(const QStringList &args);

    int execute() const;

#ifdef WITH_TESTS
    bool test() const;
#endif

    static QVariantMap addBuildEngine(const QVariantMap &map,
           const QUrl &vmUri,
           const QDateTime &creationTime,
           bool autodetected,
           const QString &sharedInstallPath,
           const QString &sharedHomePath,
           const QString &sharedTargetsPath,
           const QString &sharedSshPath,
           const QString &sharedSrcPath,
           const QString &sharedConfigPath,
           const QString &host,
           const QString &userName,
           const QString &privateKeyFile,
           quint16 sshPort,
           quint16 dBusPort,
           bool headless);
    static QVariantMap initializeBuildEngines(int version, const QString &installDir);

private:
    QString m_installDir;
    QUrl m_vmUri;
    bool m_autodetected = true;
    QString m_sharedInstallPath;
    QString m_sharedHomePath;
    QString m_sharedTargetsPath;
    QString m_sharedSshPath;
    QString m_sharedSrcPath;
    QString m_sharedConfigPath;
    QString m_host;
    QString m_userName;
    QString m_privateKeyFile;
    quint16 m_sshPort = 0;
    quint16 m_dBusPort = 0;
    bool m_headless = false;
};
