/****************************************************************************
**
** SPDX-FileCopyrightText: 2020-2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
** This file is part of the pns
**
****************************************************************************/

#ifndef PUSH_TYPES_H
#define PUSH_TYPES_H

#include <QDBusArgument>

namespace Aurora {
namespace PushNotifications {

struct Push
{
    QString data;
    QString title;
    QString message;
    QString action;
    QString image;
    QString sound;
    quint32 categoryId = 0;

    bool operator==(const Push &other) const;
    bool operator!=(const Push &other) const;
};

struct ExtendedPush
{
    QString pushId;
    Push push;

    bool operator==(const ExtendedPush &other) const;
    bool operator!=(const ExtendedPush &other) const;
};

uint qHash(const Push &key, uint seed);
uint qHash(const ExtendedPush &key, uint seed);

typedef QList<Push> PushList;

void registerTypes();

QDBusArgument &operator<<(QDBusArgument &argument, const Push &push);
const QDBusArgument &operator>>(const QDBusArgument &argument, Push &push);

} // namespace PushNotifications
} // namespace Aurora

Q_DECLARE_METATYPE(Aurora::PushNotifications::Push)
Q_DECLARE_METATYPE(Aurora::PushNotifications::PushList)

#endif
