/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MARKET_LIB_PACKAGE_HPP
#define MARKET_LIB_PACKAGE_HPP

#include "globals.hpp"

#include <map>
#include <memory>
#include <string>

namespace Market {

class PackagePrivate;

/**
 * @brief Class for getting information about the package.
 * @class Package package.hpp <market/package.hpp>
 */
class MARKET_LIB_EXPORT_SYMBOL Package
{
public:
    Package();
    Package(std::string id,
            std::string version,
            std::string developerCertificateSubgroup,
            std::string developerCertificateID,
            std::map<std::string, std::string> details);

    /**
     * @brief Get the package ID compatible with the RPM package name.
     *
     * @return Package ID.
     */
    const std::string &GetID() const;

    /**
     * @brief Get the version of the package in {version}-{release} format.
     *
     * @return Package version.
     */
    const std::string &GetVersion() const;

    /**
     * @brief Get the package developer certificate subgroup compatible with
     *        the package information from the rpmsign-external utility.
     *
     * @return Package developer certificate subgroup.
     */
    const std::string &GetDeveloperCertificateSubgroup() const;

    /**
     * @brief Get the package developer certificate key ID compatible with
     *        the package information from the rpmsign-external utility.
     *
     * @return Package developer certificate key ID.
     */
    const std::string &GetDeveloperCertificateID() const;

private:
    std::shared_ptr<PackagePrivate> m_pimpl;
};

} /* namespace Market */

#endif /* MARKET_LIB_PACKAGE_HPP */
