/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef MARKET_LIB_EVENT_FUNC_HPP
#define MARKET_LIB_EVENT_FUNC_HPP

#include "operation.hpp"
#include "package.hpp"

#include <functional>
#include <variant>

namespace Market {

/**
 * @brief The type of callback to be used when subscribing to operation
 *        status change events.
 */
using OnOperationEventFunc = std::function<void(const Operation &)>;

/**
 * @brief The type of callback to be used when subscribing to package
 *        package install, upgrade and remove events.
 */
using OnPackageEventFunc = std::function<void(const Package &)>;

/**
 * @brief A variant of two types of callbacks @ref OnOperationEventFunc
 *        and @ref OnPackageEventFunc.
 */
using OnEventFunc = std::variant<OnOperationEventFunc, OnPackageEventFunc>;

} /* namespace Market */

#endif /* MARKET_LIB_EVENT_FUNC_HPP */
