/**
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef COMMON_OPERATION_STATUS_HPP
#define COMMON_OPERATION_STATUS_HPP

#ifdef __cplusplus
#define OPERATION_STATUS_ENUM_ENTRY(CPP, C) CPP
#else
#define OPERATION_STATUS_ENUM_ENTRY(CPP, C) OPERATION_STATUS_##C
#endif

#ifdef __cplusplus
/**
 * @brief General data types and enums
 * @namespace Common
 */
namespace Common {
#endif

/**
 * @brief Possible operation statuses.
 * @enum OperationStatus
 */
enum OperationStatus {
    /** Operation queued for processing */
    OPERATION_STATUS_ENUM_ENTRY(Queued, QUEUED) = 0,
    /** Operation in progress */
    OPERATION_STATUS_ENUM_ENTRY(Processing, PROCESSING) = 10,
    /** Waiting for the package termination to complete the operation */
    OPERATION_STATUS_ENUM_ENTRY(WaitingForPackageTermination, WAITING_FOR_PACKAGE_TERMINATION) = 90,
    /** The operation was completed successfully */
    OPERATION_STATUS_ENUM_ENTRY(Succeed, SUCCEED) = 100,
    /** The operation failed with an error */
    OPERATION_STATUS_ENUM_ENTRY(Failed, FAILED) = 101,
};

#ifndef __cplusplus
typedef enum OperationStatus OperationStatus;
#endif

#ifdef __cplusplus
} /* namespace Common */
#endif

#endif /* COMMON_OPERATION_STATUS_HPP */
