/****************************************************************************
**
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

#pragma once

#include "enumerations.hpp"

#include <QDBusError>
#include <QObject>
#include <QScopedPointer>
#include <QString>

namespace Aurora {
namespace Location {

class LBSProviderSettingsPrivate;
class LBSProviderSettings : public QObject
{
    Q_OBJECT

    Q_PROPERTY(
        QString providerName READ providerName WRITE setProviderName NOTIFY providerNameChanged)
    Q_PROPERTY(Status::Enum status READ status WRITE setStatusAsync NOTIFY statusChanged)
    Q_PROPERTY(QString apiKey READ apiKey WRITE setApiKeyAsync NOTIFY apiKeyChanged)
    Q_PROPERTY(quint32 requestPeriod READ requestPeriod WRITE setRequestPeriodAsync NOTIFY
                   requestPeriodChanged)
    Q_PROPERTY(quint32 backgroundRequestPeriod READ backgroundRequestPeriod WRITE
                   setBackgroundRequestPeriodAsync NOTIFY backgroundRequestPeriodChanged)
    Q_PROPERTY(LBSBackgroundPolicy::Enum backgroundPolicy READ backgroundPolicy WRITE
                   setBackgroundPolicyAsync NOTIFY backgroundPolicyChanged)

public:
    LBSProviderSettings(QObject *parent = nullptr);
    virtual ~LBSProviderSettings();

    Q_INVOKABLE void initializeAsync();

    QString providerName() const;
    void setProviderName(const QString &name);

    Status::Enum status() const;
    void setStatusAsync(Status::Enum status);

    QString apiKey() const;
    void setApiKeyAsync(const QString &key);

    quint32 requestPeriod() const;
    void setRequestPeriodAsync(quint32 period);

    quint32 backgroundRequestPeriod() const;
    void setBackgroundRequestPeriodAsync(quint32 period);

    LBSBackgroundPolicy::Enum backgroundPolicy() const;
    void setBackgroundPolicyAsync(LBSBackgroundPolicy::Enum policy);

signals:
    void providerNameChanged(const QString &name);
    void statusChanged(Status::Enum status);
    void apiKeyChanged(const QString &key);
    void requestPeriodChanged(quint32 period);
    void backgroundRequestPeriodChanged(quint32 period);
    void backgroundPolicyChanged(LBSBackgroundPolicy::Enum policy);

    void initializeFinished(bool success);
    void validationError(QDBusError::ErrorType err);
    void error(const QString &message);

private:
    QScopedPointer<LBSProviderSettingsPrivate> m_pImpl;
};

} // namespace Location
} // namespace Aurora
