/****************************************************************************
**
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

#pragma once

#include "enumerations.hpp"

#include <QObject>
#include <QScopedPointer>
#include <QString>

namespace Aurora {
namespace Location {

class GlobalSettingsPrivate;
class GlobalSettings : public QObject
{
    Q_OBJECT

    // clang-format off
    Q_PROPERTY(Status::Enum locationStatus READ locationStatus WRITE setLocationStatusAsync NOTIFY locationStatusChanged)
    Q_PROPERTY(LocationMode::Enum locationMode READ locationMode WRITE setLocationModeAsync NOTIFY locationModeChanged)
    Q_PROPERTY(Status::Enum satelliteStatus READ satelliteStatus WRITE setSatelliteStatusAsync NOTIFY satelliteStatusChanged)
    Q_PROPERTY(Status::Enum lbsStatus READ lbsStatus WRITE setLbsStatusAsync NOTIFY lbsStatusChanged)
    Q_PROPERTY(QStringList enabledLbsProviders READ enabledLbsProviders WRITE setEnabledLbsProvidersAsync NOTIFY enabledLbsProvidersChanged)

    // Read-only properties
    Q_PROPERTY(Status::Enum satelliteSupport READ satelliteSupport NOTIFY satelliteSupportChanged)
    Q_PROPERTY(QStringList supportedLbsProviders READ supportedLbsProviders NOTIFY supportedLbsProvidersChanged)
    // clang-format on

public:
    GlobalSettings(QObject *parent = nullptr);
    virtual ~GlobalSettings();

    Q_INVOKABLE void initializeAsync();

    Status::Enum locationStatus() const;
    void setLocationStatusAsync(Status::Enum status);

    LocationMode::Enum locationMode() const;
    void setLocationModeAsync(LocationMode::Enum mode);

    Status::Enum satelliteStatus() const;
    void setSatelliteStatusAsync(Status::Enum status);

    Status::Enum lbsStatus() const;
    void setLbsStatusAsync(Status::Enum status);

    QStringList enabledLbsProviders() const;
    void setEnabledLbsProvidersAsync(QStringList providers);

    Status::Enum satelliteSupport() const;

    QStringList supportedLbsProviders() const;

signals:
    void locationStatusChanged(Status::Enum status);
    void locationModeChanged(LocationMode::Enum mode);
    void satelliteStatusChanged(Status::Enum status);
    void lbsStatusChanged(Status::Enum status);
    void enabledLbsProvidersChanged(QStringList providers);
    void satelliteSupportChanged(Status::Enum status);
    void supportedLbsProvidersChanged(QStringList providers);

    void initializeFinished(bool success);
    void error(const QString &message);

private:
    QScopedPointer<GlobalSettingsPrivate> m_pImpl;
};

} // namespace Location
} // namespace Aurora
