
/****************************************************************************
**
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

#pragma once

#include <QObject>

namespace Aurora {
namespace Location {

class Status
{
    Q_GADGET

public:
    enum class Enum : int32_t {
        Unknown = -1,
        Disabled = 0,
        Enabled = 1,
        EnumMax,
    };
    Q_ENUM(Enum)
};

class KeyStatus
{
    Q_GADGET

public:
    enum class Enum : int32_t {
        Empty = 0,
        InProgress = 1,
        InternalError = 2,
        Invalid = 3,
        Valid = 4
    };
    Q_ENUM(Enum)
};

class LBSBackgroundPolicy
{
    Q_GADGET

public:
    enum class Enum : int32_t {
        Unknown = -1,
        KeepUnchanged = 0,
        UseBackgroundPeriod = 1,
        DisableUpdates = 2,
        EnumMax,
    };
    Q_ENUM(Enum)
};

class LocationMode
{
    Q_GADGET

public:
    enum class Enum : int32_t {
        Unknown = -1,
        HighAccuracyMode = 0,
        BatterySavingMode = 1,
        DeviceOnlyMode = 2,
        EnumMax,
    };
    Q_ENUM(Enum)
};

} // namespace Location
} // namespace Aurora
