/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef AURORA_MDM_DEVICECONTROL_P_H
#define AURORA_MDM_DEVICECONTROL_P_H

#include <QObject>
#include <QDBusInterface>
#include <QDBusReply>

namespace Aurora {
namespace Mdm {

class DeviceControl;
class DeviceControlPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(DeviceControlPrivate)
    Q_DECLARE_PUBLIC(DeviceControl)

public:
    explicit DeviceControlPrivate(DeviceControl *q);

    bool reboot();
    bool shutdown();
    quint64 uptimeMsecs();

    template <typename Res>
    Res requestIface(const QString &request, Res defaultVal)
    {
        QDBusReply<Res> reply = proxyIface.call(request);
        if (!reply.isValid()) {
            qWarning() << reply.error().message();
            return defaultVal;
        }
        return reply.value();
    }

    QDBusInterface proxyIface;
    DeviceControl *q_ptr;
};

} // namespace Mdm
} // namespace Aurora

#endif // AURORA_MDM_DEVICECONTROL_P_H
