/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>
#include <QString>
#include <QVariantMap>
#include <QList>

#include <callserviceglobal.h>

namespace ru {
namespace auroraos {
namespace call {

struct CALLSERVICE_EXPORT AudioDevice
{
    Q_GADGET
    Q_PROPERTY(QString id MEMBER id)
    Q_PROPERTY(ru::auroraos::call::AudioDevice::Type type MEMBER type)
    Q_PROPERTY(bool hasInput MEMBER hasInput)
    Q_PROPERTY(bool hasOutput MEMBER hasOutput)
    Q_PROPERTY(QString name MEMBER name)
    Q_PROPERTY(QVariantMap info MEMBER info)
    Q_PROPERTY(bool isNull READ isNull)

public:
    enum Type {
        Null,
        Microphone,
        Speaker,
        Earpiece,
        WiredHeadset,
        UsbHeadset,
        Bluetooth,
    };
    Q_ENUM(Type)

    QString id;
    Type type{};
    bool hasInput{};
    bool hasOutput{};
    QString name;
    QVariantMap info;

    AudioDevice();
    AudioDevice(const QString &id, Type type, bool hasInput, bool hasOutput, const QString &name = {});

    bool isNull() const;

    bool operator==(const AudioDevice &o) const
    {
        return id == o.id
            && type == o.type
            && hasInput == o.hasInput
            && hasOutput == o.hasOutput
            && name == o.name
            && info == o.info;
    }

    bool operator!=(const AudioDevice &o) const
    {
        return !operator==(o);
    }
};

typedef QList<AudioDevice> AudioDeviceList;

} // namespace call
} // namespace auroraos
} // namespace ru

Q_DECLARE_METATYPE(ru::auroraos::call::AudioDevice)
Q_DECLARE_METATYPE(ru::auroraos::call::AudioDevice::Type)
Q_DECLARE_METATYPE(ru::auroraos::call::AudioDeviceList)
