/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef _DEVICE_FILTERS_HPP
#define _DEVICE_FILTERS_HPP

#include <QtCore/QList>
#include <QtCore/QPair>
#include <QtCore/QScopedPointer>
#include <QtCore/QString>

#include "device.hpp"

namespace Aurora {
namespace Devices {

class FilterPrivate;
class Filter
{
public:
    enum class Criteria {
        DeviceType,
        Class,
        VendorId,
        ProductId,
        Serial,
        Manufacturer,
        Product,
        ProductVersion,
        Path,
    };

    using Condition = QPair<Criteria, QStringList>;

    Filter();
    ~Filter();

    bool match(BaseDevice *device);

    void add(const Condition &condition);
    void add(const QList<Condition> &conditions);

    void clear();

    Filter &operator<<(const Condition &condition);

private:
    QScopedPointer<FilterPrivate> d_ptr;
    Q_DECLARE_PRIVATE(Filter)
    Q_DISABLE_COPY(Filter)
};

} // namespace Devices
} // namespace Aurora

#endif
