/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef DEVICE_BASE_HPP_
#define DEVICE_BASE_HPP_

#include <QMap>
#include <QObject>
#include <QSharedPointer>
#include <QVariant>

QT_BEGIN_NAMESPACE
class QDBusMessage;
QT_END_NAMESPACE

namespace Aurora {
namespace Devices {

class BaseDevice : public QObject
{
    Q_OBJECT

public:
    BaseDevice(QObject *parent = nullptr);
    ~BaseDevice() = default;

    QString path() const;
    QVariantMap rawProperties() const;

protected:
    // No api calls require args right now
    QDBusMessage call(const QString &interface, const QString &method);

    QString m_objectPath;
    QVariantMap m_properties;
};

using BaseDevicePtr = QSharedPointer<BaseDevice>;

} // namespace Devices
} // namespace Aurora

#endif // DEVICE_BASE_HPP_
