/****************************************************************************
**
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

#ifndef AC_CLIENT_CREDS_HPP
#define AC_CLIENT_CREDS_HPP

#include <cstdint>

/*!
 * @brief General data types and enums
 * @namespace aurora
 */
namespace aurora {
/*!
 * @brief Attestation related data types and enums
 * @namespace aurora::attestation
 */
namespace attestation {

/*!
 * @brief Level of attestation check.
 * @enum Level
 */
enum class Level : uint32_t {
    App = 1 << 0,        /*!< enum value App */
    Device = 1 << 1,     /*!< enum value Device */
    Full = App | Device, /*!< enum value Full */
};

/*!
 * @brief Status of attestation check
 * @enum Status
 */
enum class Status : int32_t {
    Ok = 0,
    Failed = 1,
    Unknown = -1,
};

} // namespace attestation
} // namespace aurora

#endif // AC_CLIENT_CREDS_HPP
