/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <memory>

#include "jsdialogrequest.h"

namespace Aurora {
namespace WebView {

class AlertDialogRequestInternal;

/**
 * @class AlertDialogRequest
 * @brief Represents JavaScript alert dialog request
 * 
 * Use it to process JS alert dialogs
 */
class AlertDialogRequest : public JSDialogRequest
{
    Q_GADGET

    /// URL of the web page that called the function
    Q_PROPERTY(QString sourceUrl READ sourceUrl)
    /// message from the function that triggered the dialog
    Q_PROPERTY(QString message READ message)
    /// returns true if the request is valid, do not use otherwise
    Q_PROPERTY(bool isValid READ isValid)
public:
    /**
     * @brief Constructs a new AlertDialogRequest object
     * This constructor is declared to register
     * this class in QML
     */
    AlertDialogRequest();
    AlertDialogRequest(const AlertDialogRequest &other) = default;
    /**
     * @brief Destroys the AlertDialogRequest object
     */
    ~AlertDialogRequest() = default;

    /**
     * @brief Used to exit from alert dialog and return to the web page
     */
    Q_INVOKABLE virtual void ok();

    bool isValid() const override;

private:
    AlertDialogRequest(
        QString originUrl,
        QString messageText,
        std::shared_ptr<AlertDialogRequestInternal> dialogRequestInternal);

    std::shared_ptr<AlertDialogRequestInternal> m_d;

    friend class AlertDialogRequestInternal;
};

} // namespace WebView
} // namespace Aurora

Q_DECLARE_METATYPE(Aurora::WebView::AlertDialogRequest)
