/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "certificates/clientcertificaterequest.h"
#include <memory>

namespace Aurora {
namespace WebView {

class IClient;

/**
 * @class ISslHandler
 * @brief Interface for SslHandler.
 *
 * You can implement this interface to override default SslHandler. However,
 * note that instantiating an external implementation disables default QML wrapper,
 * so you might also need to create it on your own.
 *
 * Browser engine starts using an external implementation as soon as it is created.
 * Please note that only the last created implementation is used. As soon as
 * a new implementation is instantiated, all previous implementations become invalid.
 */
class ISslHandler
{
public:
    /**
     * @brief Registers ISslHandler implementations in IClient
     * 
     * @param client can be nullptr, default one will be used in that case.
     */
    ISslHandler(IClient *client = nullptr);

    /**
     * @brief Destroy the ISslHandler object
     */
    virtual ~ISslHandler() = default;

    /**
     * @brief this method is called on each client certificate request from
     * the server (used for two-way TLS connection).
     *
     * @param clientCertificateRequest contains server info and list of certificates to choose from.
     */
    virtual void selectClientCertificate(const ClientCertificateRequest &clientCertificateRequest)
        = 0;
};

} // namespace WebView
} // namespace Aurora
