/*
 * SPDX-FileCopyrightText: Copyright 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

#include "pdfprintresult.h"

#include <memory>

namespace Aurora {
namespace WebView {

/**
 * @class IPdfPrintHandler
 * @brief Interface for PdfPrintHandler.
 * 
 * You can implement this interface to override default PdfPrintHandler. However,
 * note that instantiating an external implementation disables default QML wrapper,
 * so you might also need to create it on your own.
 *
 * Browser engine starts using an external implementation as soon as it is created.
 * Please note that only the last created implementation is used. As soon as
 * a new implementation is instantiated, all previous implementations become invalid.
 */
class IPdfPrintHandler
{
public:
    /**
     * @brief Construct a new IPdfPrintHandler object
     */
    IPdfPrintHandler();
    virtual ~IPdfPrintHandler() = default;

    /**
     * @brief called when a new pdf print result is available
     * 
     * @param pdfPrintResult object that provides interaction mechanism with pdf print results
     */
    virtual void pdfPrintResult(const PdfPrintResult &pdfPrintResult) = 0;
};

} // namespace WebView
} // namespace Aurora
