/*
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

class QQmlEngine;
class QJSEngine;

namespace Aurora {
namespace WebView {

/**
 * @class CryptoProInfoProvider
 * @brief used to get information about Crypto Pro
 *
 */
class CryptoProInfoProvider : public QObject
{
    Q_OBJECT

    /// indicates if Crypto Pro is installed in the system.
    Q_PROPERTY(bool isAvailable READ isAvailable NOTIFY availableChanged);

public:
    static QSharedPointer<CryptoProInfoProvider> GetInstance(
        QQmlEngine *qmlEngine = nullptr, QJSEngine *jsEngine = nullptr);

    virtual ~CryptoProInfoProvider();

    bool isAvailable();

signals:
    void availableChanged();

private:
    CryptoProInfoProvider();
};
} // namespace WebView
} // namespace Aurora
