/*******************************************************************************
 *
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 *
 ******************************************************************************/

#ifndef RM_LIB_MEMORY_PRESSURE_H
#define RM_LIB_MEMORY_PRESSURE_H

#include "error.h"
#include "global.h"

#include <QObject>
#include <QScopedPointer>

namespace RuntimeManager {

class MemoryPressurePrivate;
/**
 * @brief Information about the system memory level
 * @class MemoryPressure memory_pressure.h <RuntimeManager/MemoryPressure>
 *
 * The MemoryPressure class allows applications to be notified when the system
 * hits a low-memory condition, so that they can offload caches and other non
 * essential data from the main memory.
 */
class RM_EXPORT MemoryPressure: public QObject
{
    Q_OBJECT
    Q_PROPERTY(MemoryLevel level READ level NOTIFY levelChanged)

public:
    static MemoryPressure *instance();

    enum MemoryLevel {
        NormalLevel = 0,
        LowLevel = 100,
        CriticalLevel = 200,
    };
    Q_ENUM(MemoryLevel)

    MemoryLevel level() const;

Q_SIGNALS:
    void levelChanged(MemoryLevel level);

protected:
    MemoryPressure();
    ~MemoryPressure();

private:
    Q_DECLARE_PRIVATE(MemoryPressure)
    QScopedPointer<MemoryPressurePrivate> d_ptr;
};

} // namespace RuntimeManager

#endif // RM_LIB_MEMORY_PRESSURE_H
