// SPDX-FileCopyrightText: 2023 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

#ifndef STREAMCAMERAUTIL_H
#define STREAMCAMERAUTIL_H

#include <streamcamera/streamcamera.h>

#include <string>
#include <vector>

static inline std::string pix_format_str(Aurora::StreamCamera::PixelFormat format)
{
    switch (format) {
    case Aurora::StreamCamera::PixelFormat::Invalid:
        return "Invalid";
    case Aurora::StreamCamera::PixelFormat::YUV420Planar:
        return "YUV420Planar";
    case Aurora::StreamCamera::PixelFormat::YUV420SemiPlanar:
        return "YUV420SemiPlanar";
    case Aurora::StreamCamera::PixelFormat::YCbCrFlexible:
        return "YCbCrFlexible";
    default:
        return "unknown";
    }
    return "unknown";
}

static inline std::string pix_format_list_str(
    const std::vector<Aurora::StreamCamera::PixelFormat> &format_list)
{
    std::string format_list_str;
    for (auto format : format_list) {
        format_list_str += pix_format_str(format);
        format_list_str += " ";
    }
    return format_list_str;
}

#endif // STREAMCAMERAUTIL_H
