/****************************************************************************************
**
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

#ifndef SILICA_URI_OPENER_H
#define SILICA_URI_OPENER_H

#include <functional>
#include <silicaglobal.h>
#include <QJSValue>
#include <QObject>

namespace Silica {

class URIOpenerPrivate;

class SAILFISH_SILICA_EXPORT URIOpener : public QObject
{
    Q_OBJECT

public:
    URIOpener(QObject *parent = nullptr);
    ~URIOpener();

    void openUri(
        const QUrl &uri,
        const std::function<void()> &onSuccess,
        const std::function<void(const QString &)> &onError);

    void openUriWith(
        const QUrl &uri,
        const std::function<void()> &onSuccess,
        const std::function<void(const QString &)> &onError);

public slots:
    void openUri(
        const QUrl &uri,
        QJSValue onSuccessFunc = QJSValue::UndefinedValue,
        QJSValue onErrorFunc = QJSValue::UndefinedValue);

    void openUriWith(
        const QUrl &uri,
        QJSValue onSuccessFunc = QJSValue::UndefinedValue,
        QJSValue onErrorFunc = QJSValue::UndefinedValue);

private:
    Q_DECLARE_PRIVATE(URIOpener);
    URIOpenerPrivate *d_ptr;
};

} // namespace Silica

#endif // SILICA_URI_OPENER_H
