/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_TRUSTEDSOURCES_P_H
#define SAILFISH_MDM_TRUSTEDSOURCES_P_H

#include "mdm-trustedsources.h"

#include <QDBusConnection>
#include <QDBusInterface>
#include <QObject>

namespace Sailfish {
namespace Mdm {

class TrustedSourcesPrivate : public QObject
{
    Q_OBJECT
    using Result = TrustedSources::Result;

public:
    explicit TrustedSourcesPrivate(TrustedSources *q);

    Result getMissingSourceAllowed(bool &allowed);
    Result getWebPwaSourceAllowed(bool &allowed);
    Result setMissingSourceAllowed(bool allowed);
    Result setWebPwaSourceAllowed(bool allowed);
    Result getSourceList(QList<TrustedSource> &output);
    Result addSource(const QString &sourceKeyID, const QString &sourceSubject);
    Result removeSource(const QString &sourceKeyID);
    Result bindPackageToSource(const QString &packageID, const QString &sourceKeyID);

private slots:
    void onSourceAdded(const TrustedSource &source);
    void onSourceRemoved(const TrustedSource &source);
    void onSourceChanged(const TrustedSource &source);

private:
    void queryInitialSourceList();
    void subscribe(const QString &signal, QObject *receiver, const char *slot);

    Q_DISABLE_COPY(TrustedSourcesPrivate)
    QDBusConnection m_connection;
    QDBusInterface m_proxy;
    QList<TrustedSource> m_sourceList;
    TrustedSources::Result m_sourceListQueryResult;
};

} // namespace Mdm
} // namespace Sailfish

#endif // SAILFISH_MDM_TRUSTEDSOURCES_P_H
