/**
 * SPDX-FileCopyrightText: 2018-2020 Jolla Ltd.
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#ifndef SAILFISH_MDM_CALLSTATISTICS_P_H
#define SAILFISH_MDM_CALLSTATISTICS_P_H

#include "mdm-callstatistics.h"
#include "base-mdm-proxy-interface_p.h"
#include <QDBusInterface>
#include <QDBusArgument>

class QDBusPendingCallWatcher;

namespace Sailfish {
namespace Mdm {

class CallStatisticsPrivate : public BaseMdmProxyInterface
{
    Q_OBJECT
public:
    // Must match CallStatisticsProxy::StatisticData
    struct StatisticData {
        qint64 secondsSinceEpoch = 0;
        int callCount = 0;
    };

    CallStatisticsPrivate(Sailfish::Mdm::CallStatistics *parent);
    ~CallStatisticsPrivate();

    virtual void customInitUserProxyPrep();

    Sailfish::Mdm::CallStatistics *q;

public Q_SLOTS:
    void handleSearchFinished(bool success, const QList<Sailfish::Mdm::CallStatisticsPrivate::StatisticData> &dataList);
};

}
}

QDBusArgument &operator<<(QDBusArgument &, const Sailfish::Mdm::CallStatisticsPrivate::StatisticData &);
const QDBusArgument &operator>>(const QDBusArgument &, Sailfish::Mdm::CallStatisticsPrivate::StatisticData &);

Q_DECLARE_METATYPE(Sailfish::Mdm::CallStatisticsPrivate::StatisticData)
Q_DECLARE_METATYPE(QList<Sailfish::Mdm::CallStatisticsPrivate::StatisticData>)

#endif // SAILFISH_MDM_CALLSTATISTICS_P_H
