/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include "mdm-applications.h"

#include <QHash>
#include <QMutex>
#include <QDBusInterface>

namespace Sailfish {
namespace Mdm {

class PackageEntryPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(PackageEntryPrivate)
    Q_DECLARE_PUBLIC(PackageEntry)

public:
    PackageEntryPrivate(PackageEntry *q);
    virtual ~PackageEntryPrivate();

    void setup(const QString &name, const QString &version, const QString &vendor, QString release = {});

    QString name;
    QString version;
    QString vendor;
    QString release;

    PackageEntry *q_ptr;
};

class ApplicationEntryPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(ApplicationEntryPrivate)
    Q_DECLARE_PUBLIC(ApplicationEntry)

public:
    ApplicationEntryPrivate(ApplicationEntry *q);
    virtual ~ApplicationEntryPrivate();

    static ApplicationEntryPrivate *get(ApplicationEntry *entry);
    void setup(const QString &name, const PackageEntry &package, QStringList permissions = {}, QString iconPath = {});

    QString name;
    QStringList permissions;
    PackageEntry package;
    QString iconPath;

    ApplicationEntry *q_ptr;
};

class ApplicationOperationPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(ApplicationOperationPrivate)
    Q_DECLARE_PUBLIC(ApplicationOperation)

public:
    ApplicationOperationPrivate(ApplicationOperation *q);
    virtual ~ApplicationOperationPrivate();

    QString version; // Leave it so as not to break the API
    QStringList packages;
    QStringList failedPackages;
    bool finished = false;
    bool succeeded = true;
    QString errorString;

    ApplicationOperation *q_ptr;
};

class ApplicationsPrivate : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(ApplicationsPrivate)
    Q_DECLARE_PUBLIC(Applications)

public:
    ApplicationsPrivate(Applications *q);
    virtual ~ApplicationsPrivate();

    ApplicationOperation *setupOperation(quint64 id, const QStringList &packages);

public slots:
    void onOperationFinished(quint64 id, const QVariantMap &params);
    void onOperationAborted(int operationType, const QString &error);
    void onOperationSucceeded(int operationType);

public:
    QDBusInterface iface;
    QHash<quint64, ApplicationOperationPrivate *> operations;
    QMutex globalMutex;

    Applications *q_ptr;
};

} // namespace Mdm
} // namespace Sailfish
