// SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: Proprietary

#ifndef INAPPTAB_H
#define INAPPTAB_H

#include "inapptabbase.h"

/**
 * @brief Client-side API for launching and communicating with the InAppTab
 * process via D-Bus.
 */
class InAppTab : public InAppTabBase
{
    Q_OBJECT
public:
    explicit InAppTab(ActionListType type = Base, QObject *parent = nullptr);

protected:
    void sendOpenRequest(const QString &url, bool advancedAccessibility) override;
};

#endif // INAPPTAB_H
