/*
 * SPDX-FileCopyrightText: Copyright 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

#include "iclient.h"
#include "isslhandler.h"

class QQmlEngine;
class QJSEngine;

namespace Aurora {
namespace WebView {

/**
 * @class SslHandler
 * @brief Use it to handle two-way TLS (client certificate requests)
 *
 */
class SslHandler : public QObject, public ISslHandler
{
    Q_OBJECT
public:
    /// @brief default destructor
    ~SslHandler() = default;

    /// @brief creates (if doesn't exist) and returns an instance of SslHandler
    /// @return SslHandler instance
    static QSharedPointer<SslHandler> GetInstance(
        QQmlEngine *qmlEngine = nullptr, QJSEngine *jsEngine = nullptr);

    void selectClientCertificate(const ClientCertificateRequest &clientCertificateRequest) override;

signals:
    /// @brief emitted when a server requests a client certificate
    /// @param clientCertificateRequest contains server info and list of certificates to choose from
    void selectClientCertificateRequested(ClientCertificateRequest clientCertificateRequest);

private:
    explicit SslHandler(IClient *client);
};

} // namespace WebView
} // namespace Aurora
