/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

#pragma once

#include <QObject>

namespace Aurora {
namespace WebView {

/**
 * @class PdfPrintResult
 * @brief represents pdf print results
 */
class PdfPrintResult
{
    Q_GADGET

public:
    /**
     * @brief Constructs a new PdfPrintResult object with parameters
     * 
     * @param path path to the saved PDF file
     * @param printResult true when the web page has been successfully saved in PDF format
     */
    PdfPrintResult(QString path, bool printResult);

    /**
     * @brief Default conctructor for PdfPrintResult object 
     * This constructor is declared to register
     * this class in QML
     */
    PdfPrintResult();
    /**
     * @brief Destroys the PdfPrintResult object
     */
   virtual ~PdfPrintResult() = default;

    /// Path to the saved PDF file
    QString path() const;
    
    /// True when the web page has been successfully saved in PDF format
    bool printResult() const;

private:
    QString m_path;
    bool m_printResult;
};

} // namespace WebView
} // namespace Aurora

Q_DECLARE_METATYPE(Aurora::WebView::PdfPrintResult)
