/*******************************************************************************
 *
 * SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 *
 ******************************************************************************/

#ifndef RM_LIB_ERROR_H
#define RM_LIB_ERROR_H

#include "global.h"

#include <QString>

namespace RuntimeManager {

class RM_EXPORT Error
{
public:
    enum Code {
        NoError = 0,
        Failed,
        HandlerNotFound,
        HandlerFailed,
        InvalidParameters,
        NotImplemented,
        PermissionDenied,
        ProcessNotHandled,
        ApplicationNotRunning,
        ApplicationAlreadyRunning,
    };

    Error(Code code = Code::NoError, const QString &message = QString());

    ~Error() = default;

    bool isError() const;
    operator bool() const;

    Code code() const;

    QString message() const;

private:
    Code m_code;
    QString m_message;
};

} // namespace RuntimeManager

#endif // RM_LIB_ERROR_H
